using System;
using System.Collections.Generic;
using System.Linq;

class Program 
{
    static void Main() 
    {
        string[] firstLine = Console.ReadLine().Split();
        int n = int.Parse(firstLine[0]);
        long W = long.Parse(firstLine[1]);
        double eps = double.Parse(firstLine[2]);
        long[] w = new long[n];
        long[] v = new long[n];
        for (int i = 0; i < n; i++) 
        {
            string[] parts = Console.ReadLine().Split();
            w[i] = long.Parse(parts[0]);
            v[i] = long.Parse(parts[1]);
        }
        List<int> indices = new List<int>();
        long totalWeight = 0;
        long totalValue = 0;
        double ratioThreshold = 1e-9;
        var items = Enumerable.Range(0, n)
                    .Select(i => new {Index = i, Weight = w[i], Value = v[i], Ratio = (double)v[i]/w[i]})
                    .OrderByDescending(x => x.Ratio)
                    .ThenByDescending(x => x.Value)
                    .ToList();
        foreach (var item in items) 
        {
            if (totalWeight + item.Weight <= W) 
            {
                totalWeight += item.Weight;
                totalValue += item.Value;
                indices.Add(item.Index+1);
            }
        }
        Console.WriteLine(indices.Count);
        Console.WriteLine(string.Join(" ", indices));
    }
}